<?php
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/qr.php';

// Require admin login
requireAdminLogin();

// Get all employees
$pdo = getDB();
$stmt = $pdo->query("SELECT id, name, department, qr_token, created_at FROM employees ORDER BY created_at DESC");
$employees = $stmt->fetchAll();

// Get base URL (you should set this to your actual domain)
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- CSS FILE LINKS -->
    <link rel="stylesheet" href="/css/global.css">
    <link rel="stylesheet" href="/css/alert.css">
    <link rel="stylesheet" href="/css/dashboard.css">
    <!-- WEBSITE TITLE -->
    <title>Dashboard</title>
</head>

<body>

    <div class="dashboard">
        
        <div style="text-align: right; margin-bottom: 20px;">
            <a href="/admin/logout.php" style="padding: 10px 20px; background: #dc3545; color: white; text-decoration: none; border-radius: 5px;">Logout</a>
        </div>

        <form class="form" id="employeeForm">
            <div class="flex-column">
                <label>Employee Name</label>
            </div>
            <div class="inputForm">
                <input type="text" id="employee-name" class="input" placeholder="Enter Employee Name" required />
            </div>

            <div class="flex-column">
                <label>Department</label>
            </div>
            <div class="inputForm">
                <input type="text" id="employee-department" class="input" placeholder="Enter Department Name" required />
            </div>

            <button type="submit" class="button-submit">Submit</button>
        </form>

        <div class="employee-cards" id="employee-cards">
            <?php foreach ($employees as $employee): 
                $qrUrl = $baseUrl . '/attendance.php?token=' . $employee['qr_token'];
                $qrCodeUrl = generateQRCodeURL($qrUrl, 200);
            ?>
                <div class="card" data-employee-id="<?php echo htmlspecialchars($employee['id']); ?>">
                    <div class="card__img"><img src="/assets/user-background.svg" alt=""></div>
                    <div class="card__avatar"><img src="/assets/user-image.svg" alt=""></div>
                    <div class="card__title"><?php echo htmlspecialchars($employee['name']); ?></div>
                    <div class="card__subtitle"><?php echo htmlspecialchars($employee['department']); ?></div>
                    <div class="card__qr" style="margin: 15px 0;">
                        <img src="<?php echo htmlspecialchars($qrCodeUrl); ?>" alt="QR Code" style="max-width: 150px; height: auto; border: 2px solid #ddd; padding: 5px; background: white;">
                    </div>
                    <div class="card__wrapper">
                        <button class="card__btn" onclick="downloadQR('<?php echo htmlspecialchars($employee['name']); ?>', '<?php echo htmlspecialchars($qrCodeUrl); ?>')">Download QR Code</button>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

    </div>

    <div class="alert" id="alert">
        <div class="info">
            <div class="info__title" id="alert-message">lorem ipsum dolor sit amet</div>
            <button class="info__close" id="alert-close"><svg xmlns="http://www.w3.org/2000/svg" width="20" viewBox="0 0 20 20"
                    height="20">
                    <path fill="#393a37"
                        d="m15.8333 5.34166-1.175-1.175-4.6583 4.65834-4.65833-4.65834-1.175 1.175 4.65833 4.65834-4.65833 4.6583 1.175 1.175 4.65833-4.6583 4.6583 4.6583 1.175-1.175-4.6583-4.6583z">
                    </path>
                </svg></button>
        </div>
    </div>

    <script>
        const baseUrl = '<?php echo $baseUrl; ?>';
        
        // Employee form handler
        document.getElementById('employeeForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const name = document.getElementById('employee-name').value.trim();
            const department = document.getElementById('employee-department').value.trim();
            
            if (!name || !department) {
                showAlert('Please fill in all fields', 'error');
                return;
            }
            
            try {
                const response = await fetch('/api/create_employee.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ name, department })
                });
                
                const data = await response.json();
                
                if (data.success) {
                    showAlert(data.message, 'success');
                    // Clear form
                    document.getElementById('employee-name').value = '';
                    document.getElementById('employee-department').value = '';
                    // Reload page to show new employee
                    setTimeout(() => {
                        window.location.reload();
                    }, 1000);
                } else {
                    showAlert(data.message, 'error');
                }
            } catch (error) {
                showAlert('Network error. Please try again.', 'error');
            }
        });
        
        // Download QR Code
        function downloadQR(employeeName, qrUrl) {
            fetch(qrUrl)
                .then(response => response.blob())
                .then(blob => {
                    const url = window.URL.createObjectURL(blob);
                    const a = document.createElement('a');
                    a.href = url;
                    a.download = employeeName.replace(/\s+/g, '_') + '_QR_Code.png';
                    document.body.appendChild(a);
                    a.click();
                    window.URL.revokeObjectURL(url);
                    document.body.removeChild(a);
                })
                .catch(error => {
                    showAlert('Failed to download QR code', 'error');
                });
        }
        
        // Alert functions
        function showAlert(message, type = 'info') {
            const alert = document.getElementById('alert');
            const alertMessage = document.getElementById('alert-message');
            alertMessage.textContent = message;
            alert.classList.add('show');
            
            setTimeout(() => {
                hideAlert();
            }, 5000);
        }
        
        function hideAlert() {
            const alert = document.getElementById('alert');
            alert.classList.remove('show');
        }
        
        document.getElementById('alert-close').addEventListener('click', hideAlert);
        document.getElementById('alert').classList.remove('show');
    </script>

</body>

</html>
